VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Selection"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
'
' Sistema:    AxcelLib
' Classe:     Selection
'
' Criado:     04 Jan 1996
' Atualizado:
'
' Copyright  1996 by Marco Antnio Gutierrez
' Copyright  1996 by Axcel Books do Brasil
' Editora Ltda
'

Option Explicit

' Valor do Tag
Private Const SelectionOk As String = "True"

' Propriedades do objeto
Dim PathInicial As String   ' InitDir


' Determina se foi selecionado arquivo Access
Public Property Get Database() As Boolean
  Dim Banco As Database
  If frmSelection.Tag <> SelectionOk Then _
   Exit Property
  On Error GoTo BancoNoSelecionado
  Set Banco = Workspaces(0).OpenDatabase _
   (frmSelection.dlbdiretrios.Path & "\" & _
   frmSelection.flbArquivo.FileName)
  Banco.Close
  Database = True
  Exit Property
BancoNoSelecionado:
  Database = False
  Exit Property
End Property

' Retorna extenso default
Public Property Get DefaultExt() As String
  DefaultExt = frmSelection.DefaultExt
End Property

' Atribui extenso default
Public Property Let DefaultExt(Parm As String)
  frmSelection.DefaultExt = Parm
End Property

' Retorna ttulo da janela
Public Property Get DialogTitle() As String
  DialogTitle = frmSelection.Caption
End Property

' Atribui ttulo da janela
Public Property Let DialogTitle(Parm As String)
  frmSelection.Caption = Parm
End Property

' Retorna modo de edio
Public Property Get EditMode() As Boolean
  EditMode = frmSelection.EditMode
End Property

' Atribui modo de edio
Public Property Let EditMode(Parm As Boolean)
  frmSelection.EditMode = Parm
End Property

' Retorna path + arquivo selecionado
Public Property Get FileName() As String
  If frmSelection.Tag = SelectionOk Then
    FileName = frmSelection.dlbdiretrios.Path _
     & "\" & frmSelection.txtNomeArquivo.Text
  Else
    FileName = ""
  End If
End Property

' Retorna nome do arquivo
Public Property Get FileTitle() As String
  If frmSelection.Tag = SelectionOk Then
    FileTitle = frmSelection.txtNomeArquivo.Text
  Else
    FileTitle = ""
  End If
End Property

' Atribui nome de arquivo inicial
Public Property Let FileTitle(Parm As String)
  frmSelection.txtNomeArquivo.Text = Parm
End Property

' Retorna ndice selecionado
Public Property Get Index() As String
  If frmSelection.Tag <> SelectionOk Then _
   Exit Property
  If Not Database Then Exit Property
  If frmSelection.lstndices.ListIndex <> -1 Then _
   Index = frmSelection.lstndices.List _
   (frmSelection.lstndices.ListIndex)
End Property

' Retorna path inicial
Public Property Get InitDir() As String
  InitDir = PathInicial
End Property

' Atribui path inicial
Public Property Let InitDir(Parm As String)
  Dim TempPath As String
  
  ' Constri path
  If InStr(Parm, ":") = 0 Then _
   TempPath = Left(CurDir, 2)
  If Right(Parm, 1) = "\" Then
   TempPath = TempPath & Left(Parm, Len(Parm) - 1)
  Else
    TempPath = TempPath & Parm
  End If
  
  ' Valida path
  If Not CaminhoExiste(TempPath) Then _
   GoTo InitDirErro
  
  ' Atribui propriedade
  PathInicial = TempPath
  frmSelection.dlbDrives.Drive = PathInicial
  frmSelection.dlbdiretrios.Path = PathInicial
  Exit Property

' Path invlido
InitDirErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_SELERROPATH, _
   LoadResString(IDS_SELCLASSE), _
   LoadResString(IDS_SELERROPATH)
  Exit Property
End Property

' Retorna seleo de tipo de arquivo
Public Property Get ListIndex() As Integer
  ListIndex = frmSelection.cboArquivosTipo. _
   ListIndex
End Property

' Altera seleo de tipo de arquivo
Public Property Let ListIndex(Parm As Integer)
  If Parm <= frmSelection.cboArquivosTipo. _
   ListCount Then
    frmSelection.cboArquivosTipo.ListIndex = _
     Parm
  Else
    Err.Clear
    Err.Raise vbObjectError + IDS_PROPINVALIDA, _
     LoadResString(IDS_SELCLASSE), _
     LoadResString(IDS_PROPINVALIDA)
  End If
End Property

' Retorna diretrio selecionado
Public Property Get Path() As String
  Path = frmSelection.dlbdiretrios.Path
End Property

' Retorna consulta selecionada
Public Property Get Query() As String
  If frmSelection.Tag <> SelectionOk Then _
   Exit Property
  If Not Database And Not EditMode Then _
   Exit Property
  Query = frmSelection.cboconsultas.Text
End Property

' Nome default da consulta
Public Property Let Query(Parm As String)
  If EditMode Then
    frmSelection.cboconsultas.Text = Parm
  Else
    Err.Clear
    Err.Raise vbObjectError + IDS_SELERROEDIT, _
     LoadResString(IDS_SELCLASSE), _
     LoadResString(IDS_SELERROEDIT)
  End If
End Property

' Retorna estado da caixa de verificao
Public Property Get ReadOnly() As Boolean
  ReadOnly = IIf(frmSelection.chkleitura. _
   Value = 1, True, False)
End Property

' Atribui caixa de verificao
Public Property Let ReadOnly(Parm As Boolean)
  frmSelection.chkleitura.Value = _
   IIf(Parm, 1, 0)
End Property

' Retorna tabela selecionada
Public Property Get Table() As String
  If frmSelection.Tag <> SelectionOk Then _
   Exit Property
  If Not Database And Not EditMode Then _
   Exit Property
  Table = frmSelection.cboTabelas.Text
End Property

' Nome default da tabela
Public Property Let Table(Parm As String)
  If EditMode Then
    frmSelection.cboTabelas.Text = Parm
  Else
    Err.Clear
    Err.Raise vbObjectError + IDS_SELERROEDIT, _
     LoadResString(IDS_SELCLASSE), _
     LoadResString(IDS_SELERROEDIT)
  End If
End Property

' Carrega janela de seleo
Private Sub Class_Initialize()
  On Error GoTo InitErro
  Load frmSelection
  PathInicial = App.Path
  Exit Sub

' Erro na carga da janela
InitErro:
  Err.Clear
  Err.Raise vbObjectError + IDS_ERROCARGA, _
   LoadResString(IDS_SELCLASSE), _
   LoadResString(IDS_ERROCARGA)
  Exit Sub
End Sub

' Descarrega janela
Private Sub Class_Terminate()
  Unload frmSelection
End Sub

' Adiciona um item ao combo de
' tipo de arquivo
Public Sub AddItem(Item As String)
  Dim i As Integer, j As Integer
  Dim Padro As String
  
  ' Valida item
  i = InStr(Item, "(") + 1
  j = InStr(Item, ")")
  If i > 0 And j > i Then
    Padro = LCase(Mid(Item, i, j - i))
  Else
    Exit Sub
  End If
  
  ' Verifica se item j existe
  For i = 0 To frmSelection. _
   cboArquivosTipo.ListCount - 1
    If InStr(1, frmSelection. _
     cboArquivosTipo.List(i), _
     Padro, 1) <> 0 Then Exit Sub
  Next
  
  ' Atribui item
  frmSelection.cboArquivosTipo.AddItem Item
End Sub

' Exibe dilogo
Public Sub Show()
  frmSelection.Show 1
End Sub

' Verifica se path existe
Private Function CaminhoExiste _
 (Path As String) As Boolean
  Dim CurPath As String
  On Error GoTo CaminhoNoExiste
  CurPath = CurDir
  ChDir Path
  ChDir CurPath
  CaminhoExiste = True
  Exit Function
CaminhoNoExiste:
  CaminhoExiste = False
  Exit Function
End Function
